#include "General.h"
#include "InfiniteAmmo.h"
#include "engine_weap.h"
#include "weaponmgr.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

#define STYLE_C4 0 // note that this list reflects the list in leveledit
#define STYLE_BEACON 6
#define WeaponDefID 0xB001

int OldTime = 0;

void Enable_Infinite_Ammo() 
{
	for (WeaponDefinitionClass *Def = (WeaponDefinitionClass*)DefinitionMgrClass::Get_First(0xB001);Def;Def = (WeaponDefinitionClass*)DefinitionMgrClass::Get_Next(Def,0xB001)) 
	{
		if (Def->Style != STYLE_C4 && Def->Style != STYLE_BEACON) 
		{
			int NegOne = -1;
			Def->MaxInventoryRounds = NegOne;
		}
//		Console_Output("Def Name = %s, MaxInventoryRounds = %d\n", Def->Get_Name(), (int)Def->MaxInventoryRounds);
	}
}

// this enables infinite ammo on the weapon every player in-game has currently
void Set_Clip_Bullet_Count_All_Players()
{
	for (SLNode<cPlayer>* PlayerIter = Get_Player_List()->Head(); (PlayerIter != NULL); PlayerIter = PlayerIter->Next())
	{
		cPlayer *p = PlayerIter->Data();
		GameObject* obj = Get_GameObj(p->Get_Id());
		if (p->IsActive && obj)
		{	
			const char* CurrentWeapon = Get_Current_Weapon(obj);
			if (CurrentWeapon)
			{
				const WeaponDefinitionClass* Def = Get_Weapon_Definition(CurrentWeapon);

				if (Def->Style != STYLE_C4 && Def->Style != STYLE_BEACON) 
				{
					//					Set_Current_Bullets(obj, 4);

//					if (Get_Clip_Bullets(obj, CurrentWeapon) != -1)
//				{
//						Set_Current_Clip_Bullets(obj, -1);
//					}

				}
			}
		}
	}	
}

void InfiniteAmmo::OnObjectCreate(void *data,GameObject *obj)
{
	if ( Commands->Is_A_Star(obj) )
	{
		Attach_Script_Once(obj, "InfiniteAmmo_GrantPowerup_Created", "");
	}

	if ( obj->As_PhysicalGameObj() && obj->As_PhysicalGameObj()->As_PowerUpGameObj() )
	{
		Attach_Script_Once(obj, "InfiniteAmmo_Powerup", "");
	}
}

void InfiniteAmmo::OnLoadLevel()
{
//	Console_Output(__FUNCTION__ "\n");
	Enable_Infinite_Ammo();
}

/* void InfiniteAmmo::OnThink()
{
	int NewTime = (int)time(NULL);

	if ( (NewTime - OldTime) >= 1)
	{
		OldTime = NewTime;
		//		Console_Output("One...\n");
//		Set_Clip_Bullet_Count_All_Players();
	}
} */

InfiniteAmmo::InfiniteAmmo()
{
//	RegisterEvent(EVENT_THINK_HOOK,this);
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK, this);
}

InfiniteAmmo::~InfiniteAmmo()
{
//	UnregisterEvent(EVENT_THINK_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK, this);
}

void InfiniteAmmo_GrantPowerup_Created::Created(GameObject *obj) 
{
	Commands->Start_Timer(obj, this, 1.0f, 500);
}

void InfiniteAmmo_GrantPowerup_Created::Timer_Expired(GameObject *obj, int number)
{
	if (number == 500)
	{
		Grant_Powerup(obj, "CnC_Ammo_Crate");
	}
}

void InfiniteAmmo_GrantPowerup_Created::Custom(GameObject *obj, int type, int param, GameObject *sender)
{
	if (type == 5)
	{
//		Console_Output("Custom triggered\n"); // DEBUG CRAP

		const char *CurrentWeapon = Get_Current_Weapon(obj);
		if ( CurrentWeapon == NULL ) return;

//		Console_Output("Current weapon = %s\n", CurrentWeapon); // DEBUG CRAP

//		WeaponBagClass *w = obj->As_PhysicalGameObj()->As_ArmedGameObj()->Get_Weapon_Bag();
//		int x = w->Get_Count();
//		
		ProxyClipBullets = Get_Clip_Bullets(obj, "Weapon_MineProximity_Player"); 
		ProxyBullets = Get_Bullets(obj, "Weapon_MineProximity_Player");

		RemoteClipBullets = Get_Clip_Bullets(obj, "CnC_Weapon_MineRemote_Player_2Max"); 
		RemoteBullets = Get_Bullets(obj, "CnC_Weapon_MineRemote_Player_2Max");
		RemoteClipBullets2 = Get_Clip_Bullets(obj, "CnC_Weapon_MineRemote_Player"); 
		RemoteBullets2 = Get_Bullets(obj, "CnC_Weapon_MineRemote_Player");

		TimedClipBullets = Get_Clip_Bullets(obj, "CnC_Weapon_MineTimed_Player"); 
		TimedBullets = Get_Bullets(obj, "CnC_Weapon_MineTimed_Player");
		TimedClipBullets2 = Get_Clip_Bullets(obj, "CnC_Weapon_MineTimed_Player_2Max"); 
		TimedBullets2 = Get_Bullets(obj, "CnC_Weapon_MineTimed_Player_2Max");


		Grant_Powerup(obj, "CnC_Ammo_Crate");

		Set_Clip_Bullets(obj, "Weapon_MineProximity_Player", ProxyClipBullets);
		Set_Bullets(obj, "Weapon_MineProximity_Player", ProxyBullets);

		Set_Clip_Bullets(obj, "CnC_Weapon_MineRemote_Player_2Max", RemoteClipBullets); 
		Set_Bullets(obj, "CnC_Weapon_MineRemote_Player_2Max", RemoteBullets);
		Set_Clip_Bullets(obj, "CnC_Weapon_MineRemote_Player", RemoteClipBullets2); 
		Set_Bullets(obj, "CnC_Weapon_MineRemote_Player", RemoteBullets2);

		Set_Clip_Bullets(obj, "Weapon_MineTimed_Player", TimedClipBullets); 
		Set_Bullets(obj, "Weapon_MineTimed_Player", TimedBullets);
		Set_Clip_Bullets(obj, "CnC_Weapon_MineTimed_Player_2Max", TimedClipBullets2); 
		Set_Bullets(obj, "CnC_Weapon_MineTimed_Player_2Max", TimedBullets2);

//		Commands->Send_Custom_Event(0, obj, 6, 0, 2.0f);
	}
	if (type == 6)
	{

	}	

/*		for (int i = 0;i < x;i++)
		{
			if (w->Peek_Weapon(i))
			{
//				Console_Output("Weapon = %s\n", w->Peek_Weapon(i)->Get_Name()); // DEBUG CRAP
				WeaponClass *wc = w->Peek_Weapon(i);
				int Style = wc->Get_Style();

				if (Style != STYLE_C4 && Style != STYLE_BEACON) 
				{
//					Console_Output("Inner loop reached\n"); // DEBUG CRAP
					Commands->Select_Weapon(obj, w->Peek_Weapon(i)->Get_Name());
					Grant_Powerup(obj, "CnC_Ammo_Crate");
				}
			}
		}
		Commands->Select_Weapon(obj, CurrentWeapon); */
}

void InfiniteAmmo_Powerup::Custom(GameObject *obj,int type,int param,GameObject *sender)
{
	if ((type == CUSTOM_EVENT_POWERUP_GRANTED) && (sender))
	{
		Commands->Send_Custom_Event(0, sender, 5, 0, 1.0f);
	}
}

void InfiniteAmmo_Powerup::Timer_Expired(GameObject *obj, int number)
{
	if (number == 1)
	{
		Grant_Powerup(obj, "CnC_Ammo_Crate");
	}
}

ScriptRegistrant<InfiniteAmmo_Powerup> InfiniteAmmo_Powerup_Registrant("InfiniteAmmo_Powerup","");
ScriptRegistrant<InfiniteAmmo_GrantPowerup_Created> InfiniteAmmo_GrantPowerup_Created_Registrant("InfiniteAmmo_GrantPowerup_Created","WeaponDef:string");

InfiniteAmmo infiniteAmmo;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &infiniteAmmo;
}
